import numpy as np
import pandas as pd

temperatures = [10, 25, 50, 75, 100, 150, 200, 250, 300, 325, 350, 375]

with open("coercive_fields.tsv", "w") as f:
	print("temperature_K coercive_field_Oe", file=f)
	for T in temperatures:
		filename=f"loop_{T}K.tsv"
		df = pd.read_csv(filename, sep=r'\s+')

		# Compute the sign of each element
		signs = np.sign(df['m_IP_emu'])

		# Compute the differences between consecutive signs
		sign_changes = np.diff(signs)

		# Indices where the sign changes (zero-crossing)
		crossing_indices = np.where(sign_changes != 0)[0]

		# Indices before zero-crossing
		before_crossing = crossing_indices

		coercive_fields = []

		for index_before_crossing in before_crossing:
			index_after_crossing = index_before_crossing + 1
			
			x1 = df.iloc[index_before_crossing]['m_IP_emu']
			x2 = df.iloc[index_after_crossing]['m_IP_emu']

			y1 = df.iloc[index_before_crossing]['H_IP_Oe']
			y2 = df.iloc[index_after_crossing]['H_IP_Oe']

			# For np.interp the x values must be strictly increasing
			if x1 > x2:
				x1, x2 = x2, x1
				y1, y2 = y2, y1

			coercive_fields.append(np.interp(0.0, [x1, x2], [y1, y2]))

		print(T, np.mean(np.abs(coercive_fields)), file=f)
