# /bin/bash

# extract the data files for use in tikz figures

# sort the data into files according to which is the number in the last column
# This is the period of the periodic orbit in units of the forcing period.
# 0 = equilibrium point, -1 = chaotic (more than 100) 
# in addition, filter out comment lines and remove the first 50 columns as these are non-numeric
# These secondary files are used by tikz to generate Figure 1 (a) and (c)

cat LV_ODE_alpha_0p0000_kappa0_0p2500_summary.txt | grep -v "^# " | grep " 1$"    | awk '{print substr($0,51)}' > LV_ODE_alpha_0p0000_kappa0_0p2500_summary_1.txt
cat LV_ODE_alpha_0p0000_kappa0_0p2500_summary.txt | grep -v "^# " | grep " 2$"    | awk '{print substr($0,51)}' > LV_ODE_alpha_0p0000_kappa0_0p2500_summary_2.txt
cat LV_ODE_alpha_0p0000_kappa0_0p2500_summary.txt | grep -v "^# " | grep " 4$"    | awk '{print substr($0,51)}' > LV_ODE_alpha_0p0000_kappa0_0p2500_summary_4.txt
cat LV_ODE_alpha_0p0000_kappa0_0p2500_summary.txt | grep -v "^# " | grep " 8$"    | awk '{print substr($0,51)}' > LV_ODE_alpha_0p0000_kappa0_0p2500_summary_8.txt
cat LV_ODE_alpha_0p0000_kappa0_0p2500_summary.txt | grep -v "^# " | grep " -1$"   | awk '{print substr($0,51)}' > LV_ODE_alpha_0p0000_kappa0_0p2500_summary_chaos.txt
cat LV_ODE_alpha_0p0000_kappa0_0p2500_summary.txt | grep -v "^# " | grep -v " 1$" | grep -v " 2$" | grep -v " 4$" | grep -v " 8$" | grep -v " -1$" | awk '{print substr($0,51)}' > LV_ODE_alpha_0p0000_kappa0_0p2500_summary_more.txt

# the alpha = 1 case only has lines ending with 0 and 2
cat LV_ODE_alpha_1p0000_kappa0_0p2500_summary.txt | grep -v "^# " | grep -v " 0$" | awk '{print substr($0,51)}' > LV_ODE_alpha_1p0000_kappa0_0p2500_summary_only_non_eqm.txt


