%%Already saved data ko nikaal lo
clc; clear;
format long;

% for future uses
Error_Text = ['User cancelled operation'];

% MATLAB k files lelo
[file, path] = uigetfile('*.mat', 'Select a MATLAB Data File');

if isequal(file, 0)
    h = msgbox(Error_Text, 'Oh! No files selected', 'help');
    return;  % Rukk ja oh dil diwane
end

% Load Selected Data
load(fullfile(path, file));
%% Data Sort
% LAF k liye
meanLAF = mean(allLAF', 1); 
allLAF = cellfun(@transpose, num2cell(meanLAF, 1), 'UniformOutput', false);

% Time k liye
Time_Num=datenum(allTime);
Initial_Time=Time_Num(1,1);

for i=1:length(allTime);
    Time_Step(i,:) = [Time_Num(i,1) - Initial_Time]*24;
end

Time_Num_Cell={}; Time_Date_Cell={};
for i=1:length(allLAF);
    Time_Date_Cell{i} = allTime'; %maybe useful in future
    Time_Num_Cell{i} = Time_Step';
end

% Temp k liye
allTemp = cellfun(@transpose, num2cell(allTemp', 1), 'UniformOutput', false);

%% Triming k liye
% Determine initial trimming range
TimeMin = min(cellfun(@min, Time_Num_Cell));
TimeMax = max(cellfun(@max, Time_Num_Cell));

% Create Figure for Visualization
fig = figure(Name='DTS - Time v/s Temp', NumberTitle='off', Position= [100, 100, 900, 600]);

% Create Axes for Plot
ax = axes(Parent= fig, Position=[0.1, 0.2, 0.8, 0.7]);
xlabel(ax, 'Time [h]');
ylabel(ax, 'Temperature [degC]');
title(ax, sprintf('DTS Temperature Profile'));
grid on;
hold on;

% Plot with Temperature Gradient
cmap = colormap(jet); % Set colormap
caxis auto

% Slider UI
slider = uicontrol(Style="slider", Min=1, Max=length(allLAF), Value=1, Units="normalized", Position=[0.1, 0.01, 0.8, 0.03]);%left bottom width height

% Labels for Time Display
LAFText = uicontrol(Style='text', Units='normalized', Position=[0.35, 0.06, 0.3, 0.05], ...
    String=sprintf('LAF (m): %.3f', allLAF{1}), FontSize= 12, FontWeight='bold');

% LAF k Trimming k liye
trimMinLabel = uicontrol(Style='text', Units='normalized', Position=[0.1, 0.07, 0.12, 0.05],String='Start Time (h):', FontSize= 10);
trimMinBox = uicontrol(Style='edit', Units='normalized', Position=[0.21, 0.08, 0.1, 0.05], ...
    String=num2str(TimeMin), FontSize=10, Callback= @(src, event) updatePlot(slider, fig));%left bottom width height

trimMaxLabel = uicontrol(Style='text',Units='normalized', Position=[0.68, 0.07, 0.12, 0.05], String='End Time (h):',FontSize=10);
trimMaxBox = uicontrol(Style='edit', Units='normalized', Position=[0.79, 0.08, 0.1, 0.05], ...
    String= num2str(TimeMax), FontSize= 10, Callback= @(src, event) updatePlot(slider, fig));

% Store karlo bhai GUI elements guidata mai
data.LAFText = LAFText;
data.ax = ax;
data.slider = slider;
data.allLAF = allLAF;
data.allTemp = allTemp;
data.allTime = allTime;
data.Time_Num_Cell = Time_Num_Cell;
data.cmap = cmap;
data.trimMinBox = trimMinBox;
data.trimMaxBox = trimMaxBox;
guidata(fig, data);

% callback function
slider.Callback = @(src, event) updatePlot(src, fig);

%% Function jo Plot update kare Based on Slider and Trim Range
function updatePlot(source, fig)
    data = guidata(fig);  % stored data retrive karna h
    idx = round(data.slider.Value);  % slider index (rounded) values lelo
    
    % trimming values lelo
    TimeMin = str2double(data.trimMinBox.String);
    TimeMax = str2double(data.trimMaxBox.String);
    
    % trimming range se data short/sort karo
    validIndices = (data.Time_Num_Cell{idx} >= TimeMin) & (data.Time_Num_Cell{idx} <= TimeMax);
    TimeTrimmed = data.Time_Num_Cell{idx}(validIndices);
    tempTrimmed = data.allTemp{idx}(validIndices);
    
    % pichla plot hatao
    cla(data.ax);
    hold(data.ax, 'on');
    
    % temperature Normalize karo for colormap
    if ~isempty(tempTrimmed)
        normTemp = (tempTrimmed - min(tempTrimmed)) / (max(tempTrimmed) - min(tempTrimmed));
        colorIndices = round(normTemp * (size(data.cmap, 1) - 1)) + 1;
        
        % new line segments banao with temperature gradient
        for k = 1:length(TimeTrimmed)-1
            plot(data.ax, TimeTrimmed(k:k+1), tempTrimmed(k:k+1), 'Color', data.cmap(colorIndices(k), :), 'LineWidth', 1.5);
        end
    end
    
    % Update time label
    set(data.LAFText, 'String', sprintf('LAF (m): %.3f', data.allLAF{idx}));
    drawnow; % Refresh figure
end