%%Already saved data ko nikaal lo
clc; clear;
format long;

% for future uses
Error_Text = ['User cancelled operation'];

% MATLAB k files lelo
[file, path] = uigetfile('*.mat', 'Select a MATLAB Data File');

if isequal(file, 0)
    h = msgbox(Error_Text, 'Oh! No files selected', 'help');
    return;  % Rukk ja oh dil diwane
end

% Load Selected Data
load(fullfile(path, file));

% Converting to cells
allLAF = cellfun(@transpose, num2cell(allLAF, 1), 'UniformOutput', false);
allTemp = cellfun(@transpose, num2cell(allTemp, 1), 'UniformOutput', false);
allTime = num2cell(allTime');

% Determine initial trimming range
lafMin = min(cellfun(@min, allLAF));
lafMax = max(cellfun(@max, allLAF));

% Create Figure for Visualization
fig = figure(Name='DTS Temperature Profile', NumberTitle='off', Position= [100, 100, 900, 600]);

% Create Axes for Plot
ax = axes(Parent= fig, Position=[0.1, 0.2, 0.8, 0.7]);
xlabel(ax, 'Length Along Fiber [m]');
ylabel(ax, 'Temperature [degC]');
title(ax, sprintf('DTS Temperature Profile'));
grid on;
hold on;

% Plot with Temperature Gradient
cmap = colormap(jet); % Set colormap
caxis auto

% Slider UI
slider = uicontrol(Style="slider", Min=1, Max=length(allTime), Value=1, Units="normalized", Position=[0.1, 0.01, 0.8, 0.03]);%left bottom width height

% Labels for Time Display
timeText = uicontrol(Style='text', Units='normalized', Position=[0.35, 0.06, 0.3, 0.05], ...
    String=sprintf('Time: %s', allTime{1}), FontSize= 12, FontWeight='bold');

% LAF k Trimming k liye
trimMinLabel = uicontrol(Style='text', Units='normalized', Position=[0.1, 0.07, 0.1, 0.05],String='Min LAF:', FontSize= 10);
trimMinBox = uicontrol(Style='edit', Units='normalized', Position=[0.19, 0.08, 0.1, 0.05], ...
    String=num2str(lafMin), FontSize=10, Callback= @(src, event) updatePlot(slider, fig));%left bottom width height

trimMaxLabel = uicontrol(Style='text',Units='normalized', Position=[0.68, 0.07, 0.1, 0.05], String='Max LAF:',FontSize=10);
trimMaxBox = uicontrol(Style='edit', Units='normalized', Position=[0.77, 0.08, 0.1, 0.05], String= num2str(lafMax), ...
    FontSize= 10, Callback= @(src, event) updatePlot(slider, fig));

% Store karlo bhai GUI elements guidata mai
data.timeText = timeText;
data.ax = ax;
data.slider = slider;
data.allLAF = allLAF;
data.allTemp = allTemp;
data.allTime = allTime;
data.cmap = cmap;
data.trimMinBox = trimMinBox;
data.trimMaxBox = trimMaxBox;
guidata(fig, data);

% callback function
slider.Callback = @(src, event) updatePlot(src, fig);

% Function jo Plot update kare Based on Slider and Trim Range
function updatePlot(source, fig)
    data = guidata(fig);  % stored data retrive karna h
    idx = round(data.slider.Value);  % slider index (rounded) values lelo
    
    % trimming values lelo
    lafMin = str2double(data.trimMinBox.String);
    lafMax = str2double(data.trimMaxBox.String);
    
    % trimming range se data short/sort karo
    validIndices = (data.allLAF{idx} >= lafMin) & (data.allLAF{idx} <= lafMax);
    lafTrimmed = data.allLAF{idx}(validIndices);
    tempTrimmed = data.allTemp{idx}(validIndices);
    
    % pichla plot hatao
    cla(data.ax);
    hold(data.ax, 'on');
    
    % temperature Normalize karo for colormap
    if ~isempty(tempTrimmed)
        normTemp = (tempTrimmed - min(tempTrimmed)) / (max(tempTrimmed) - min(tempTrimmed));
        colorIndices = round(normTemp * (size(data.cmap, 1) - 1)) + 1;
        
        % new line segments banao with temperature gradient
        for k = 1:length(lafTrimmed)-1
            plot(data.ax, lafTrimmed(k:k+1), tempTrimmed(k:k+1), 'Color', data.cmap(colorIndices(k), :), 'LineWidth', 1.5);
        end
    end
    
    % Update time label
    set(data.timeText, 'String', sprintf('Time: %s', data.allTime{idx}));
    drawnow; % Refresh figure
end