%%Already saved data ko nikaal lo
clc; clear;
format long;

% for future uses
Error_Text = ['User cancelled operation'];

% MATLAB k files lelo
[file, path] = uigetfile('*.mat', 'Select a MATLAB Data File');

if isequal(file, 0)
    h = msgbox(Error_Text, 'No files selected', 'help');
    return;  % Rukk ja oh dil diwane
end

% Load Selected Data
load(fullfile(path, file));

% Compute Mean LAF
allLAF_T = transpose(allLAF);
meanLAF = mean(allLAF_T, 1); 
Time_Num = datenum(allTime);

% Create Meshgrid
[X, Y] = meshgrid(meanLAF, Time_Num);
Z = transpose(allTemp);

% Create Main Figure
hFig = figure(Position= [100, 100, 900, 600]);

% Plot Heatmap in Upper Section
hAx = axes(Parent=hFig, Position=[0.1, 0.2, 0.85, 0.75]); %Position UI panel
hImage = imagesc(hAx, meanLAF, Time_Num, Z);
set(hAx, 'YDir', 'normal'); % Correct y-axis direction
colormap(jet);
colorbar;
xlabel('Length at Fiber (m)');
ylabel('Date & Time');

% Set Date Format on Y-Axis
yticks(Time_Num(1:round(end/10):end)); % Reduce tick labels
yticklabels(datestr(Time_Num(1:round(end/10):end), 'yyyy-MM-dd HH:mm'));
%ytickformat('yyyy-MM-dd HH:mm'); % Set format

title('Heat Map');

% Enable data cursor mode with custom tip
dcm = datacursormode(hFig);
set(dcm, 'Enable', 'on', 'UpdateFcn', @(src, event) customDataTip(src, event, Z, meanLAF, allTime));

% Create UI Panel figure k liye
hPanel = uipanel(Parent=hFig, Title='Trim & Save Data', Position= [0.1, 0.02, 0.8, 0.1], FontSize=10);

% Aagay se kaato
uicontrol(Parent=hPanel,Style="text",String='Trim Start Length', Position= [10, 18, 100, 20], FontSize= 10);
hFrontTrim = uicontrol(Parent=hPanel, Style='edit', Position=[120, 18, 80, 25], FontSize=10);

% Piche se kaato
uicontrol(Parent=hPanel,Style="text",String='Trim end Length', Position= [220, 18, 100, 20], FontSize= 10);
hBackTrim = uicontrol(Parent=hPanel, Style='edit', Position=[330, 18, 80, 25], FontSize=10);

% Trim kardo ab
hApplyButton = uicontrol(Parent=hPanel,Style="pushbutton",String='Trim Data', Position=[440, 13, 100, 35], FontSize=10, Callback=@applyTrim);

% Isko save Karlo
hSaveButton = uicontrol(Parent=hPanel,Style="pushbutton",String='Save Trimed Data',Position=[560, 13, 150, 35],FontSize=10, Callback=@saveTrimmedData, Enable='off');

% Sab UI ko store karo
handles.hFrontTrim = hFrontTrim;
handles.hBackTrim = hBackTrim;
handles.hImage = hImage;
handles.hAx = hAx;
handles.hSaveButton = hSaveButton;
handles.meanLAF = meanLAF;
handles.allTime = allTime; % Now using DateTime format
handles.Time_Step = Time_Step; % Now using Time format
handles.Time_Num = Time_Num; % Now using DateNUM format
handles.Z = Z;
guidata(hFig, handles); % Store handles in the figure

%% Trim and Update karne k liye #Heatmap ko
function applyTrim(~, ~)
    handles = guidata(gcf); % Retrieve stored UI elements
    
    % Input values ko uthaya h
    frontTrim = str2double(get(handles.hFrontTrim, 'String'));
    backTrim = str2double(get(handles.hBackTrim, 'String'));
    
    % Valid h na input?
    if isnan(frontTrim) || isnan(backTrim) || frontTrim >= backTrim
        errordlg('Invalid trim values. Ensure front trim < back trim.', 'Input Error');
        return;
    end
    
    % Trim karo sab
    validIdx = (handles.meanLAF >= frontTrim) & (handles.meanLAF <= backTrim);
    trimmedLAF = handles.meanLAF(validIdx);
    Ztrim = handles.Z(:, validIdx);
    
    % Update Heatmap (kuch naya nahi chahiye)
    set(handles.hImage, 'XData', trimmedLAF, 'CData', Ztrim);
    set(handles.hAx, 'XLim', [min(trimmedLAF), max(trimmedLAF)]); % Adjust axes

    %%Y-axis ko update karne k liye (Y-Tick)
    %yticks(handles.Time_Num(1:round(end/10):end)); % Reduce number of tick labels
    %ytickformat('yyyy-MM-dd HH:mm'); % Set format

    title(handles.hAx, sprintf('Trimmed Data (%.2f ≤ Length at Fiber ≤ %.2f)', frontTrim, backTrim));

    % Store karo sab Trimmed Data taaki alag se save kar sako
    handles.trimmedLAF = trimmedLAF;
    handles.Ztrim = Ztrim;
    handles.validIdx = validIdx; % Store valid indexes for time trimming
    guidata(gcf, handles); % Save updated handles

    % Save Button bhi hona chahiye
    set(handles.hSaveButton, 'Enable', 'on');
    
    disp('Trimming done.');
end

%% Function Trimmed Data ko save karne k liye
function saveTrimmedData(~, ~)
    handles = guidata(gcf); % Retrieve stored UI elements

    % Extract karna h trimmed data
    trimmedLAF = handles.trimmedLAF; % Extracting LAF values
    allLAF=transpose(trimmedLAF);
    Ztrim = handles.Ztrim; % Extract temp
    allTemp = transpose(Ztrim);
    Time_Step = handles.Time_Step; % Extract trimmed time safely
    allTime = handles.allTime; % Extract time safely

    %Additional Block for LAF Adjustment
    allLAF_2=[];
    for i=1:width(allTemp);
        allLAF_2(i,:)=allLAF;
    end
    allLAF=allLAF_2'

    % kaha save hoga?
    [file, path] = uiputfile('Trimmed_DTS_Data.mat', 'Save Trimmed Data');
    if file
        save(fullfile(path, file), 'allLAF', 'allTemp', 'allTime', 'Time_Step'); % Save as independent variables
        disp(['Trimmed data saved as ', fullfile(path, file)]);
    end
end
%% For Pop-up vala Data
function outputText = customDataTip(~, eventObj, Z, meanLAF, allTime)
    pos = eventObj.Position;

    % Extract x (meanLAF) and y (datetime) values
    xVal = pos(1);  % meanLAF value
    yVal = pos(2);  % datetime value

    % nearest indices in data
    [~, col] = min(abs(meanLAF - xVal));
    [~, row] = min(abs(datenum(allTime) - datenum(yVal)));

    % Get the temp value
    zVal = Z(row, col);
    
    % Output
    outputText = {
        ['Length at Fiber (m): ', num2str(meanLAF(col))]
        ['Time: ', datestr(allTime(row), 'dd-mmm-yyyy HH:MM:SS')]
        ['Temp (degC): ', num2str(zVal)]
    };
end