%# For data extrction to ".mat" Files

%########## Data Arrangement type ##########%
% Single has these:
% 1. LAF - Length along fiber; % 2. ST - Stoke Intensity
% 3. AST - Anti-Stoke Intensity; % 4. TMP - Temp degree in Cel
% Start and end time

% Double ended has these:
% 1. LAF - Length along fiber; % 2. ST - Stoke Intensity
% 3. AST - Anti-Stoke Intensity;  % 4. REV-ST - Reverse Stoke Intensity
% 5. REV-AST - Reverse Anti-Stoke Intensity; % 6. TMP - Temp degree in Cel
% Start and end time

clear;
clc;
format long;
tic

% for future uses
Error_Text = ['User cancelled operation'];

% Multiple XML files ko select karne k liye
[fileNames, pathname] = uigetfile('*.xml', 'Select karo bhai XML Files', 'MultiSelect', 'on');


if isequal(fileNames, 0)
    h = msgbox(Error_Text, 'No files selected', 'help');
    return;  % Rukk ja oh dil diwane
end

% Khali MATRIX k maze lo
Time_Num=[];
allLAF = [];
allTemp = [];

%Counting Stars: I mean fies
FLen=length(fileNames);

WB = waitbar(0, sprintf('Data extracted: 1 of %d', FLen));

% Sab Files Check Karo
for i = 1:FLen
    % Read the XML file as a string
    filePath = fullfile(pathname, fileNames{i});
    xmlData = xmlread(filePath);

    %######### MAI SAMAY HOON #########%
    % sab XML DOM object ko string banao
    xmlString = xmlwrite(xmlData);

    % Extract start and end times
    Matches_Start = regexp(xmlString, '<startDateTimeIndex>(.*?)</startDateTimeIndex>', 'tokens');
    Matches_End = regexp(xmlString, '<endDateTimeIndex>(.*?)</endDateTimeIndex>', 'tokens');
    
    % Check valid timestamps
    if isempty(Matches_Start) || isempty(Matches_End)
        warning(['No time data found in file: ', fileNames{i}]);
        continue; % Skip this file if no valid time found
    end

    % Convert timestamps to MATLAB formatwa
    Time_Start = datetime(Matches_Start{1}, 'InputFormat', 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX', 'TimeZone', 'UTC');
    Time_End = datetime(Matches_End{1}, 'InputFormat', 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX', 'TimeZone', 'UTC');
    
    %######### AAO TAAPMAAN DEKHEN #########%
    % Finding NEMO (logged Data) elements
    logDataNodes = xmlData.getElementsByTagName('logData');

    % Zero arrays
    lafValues = [];
    tempValues = [];

    % Looping logData
    for j = 0:logDataNodes.getLength - 1
        logEntry = logDataNodes.item(j);
        dataNode = logEntry.getElementsByTagName('data');

        for k = 0:dataNode.getLength - 1
            dataText = char(dataNode.item(k).getTextContent);
            dataValues = str2double(strsplit(dataText, ','));

            if length(dataValues) >= 3  % Ensure LAF and TMP exist
                lafValues(end+1) = dataValues(1);  % First column: LAF
                tempValues(end+1) = dataValues(end);  % Last column: Temperature (TMP)
            end
        end
    end

    % Store extracted data
    allLAF(:,i) = lafValues;
    allTemp(:,i) = tempValues;
    Time_Num(i,:) = [datenum(Time_Start), datenum(Time_End)];

    waitbar(i / FLen, WB, sprintf('Data extracted: %d of %d', i, FLen));
end

Initial_Time=Time_Num(1,1);
allTime = datetime(mean(Time_Num, 2), 'ConvertFrom', 'datenum'); % Convert to datetime

Time_Step=[];
close(WB);

for i=1:length(allTime);
    Time_Step(i,:) = [Time_Num(i,1) - Initial_Time]*24;
end
%clearvars -except allLAF allTemp allTime Time_Step
% save Data_from_XML_Files
[filename,pathname]=uiputfile('*.mat', 'Save extracted data as')

Fin_Text = ['All files have been processed and saved. Press "OK" to close'];

% pop-up  message vala
%h = msgbox(Fin_Text, 'Yay!', 'help');

% If the user does not cancel
if ischar(filename)
    clearvars -except allLAF allTemp allTime Time_Step filename pathname Fin_Text
    save(fullfile(pathname, filename));
    % pop-up  message vala
    h = msgbox(Fin_Text, 'Yay!', 'help');
else
    clearvars -except Error_Text
    h = msgbox(Error_Text, 'No data saved', 'help');
    return;  % Rukk ja oh dil diwane;
end

toc