



from SSP import strongly_segregated_polygon as ssp
from SSP import read_polygon_geomertry as read_geometry
from SSP import write_polygon_strucure as write_poly
from scipy.optimize import minimize 
import matplotlib.pyplot as plt
import numpy as np
import random
import argparse




# updates the dconst list
def update_const_list(dconst_list):
    
    const_list=const_list0.copy()
    
    lambda_xx= 1+dconst_list[0]#change \epsilon_xx in x direction
    #print(lambda_xx)
    lambda_yy= 1+dconst_list[2]#change \epsilon_yy in y direction
    const_list[0]=lambda_xx*const_list0[0] #v1x periodicity
    const_list[1]=lambda_xx*const_list0[1]+dconst_list[1]*const_list0[2] #v2x periodicity
    const_list[2]=lambda_yy*const_list0[2] #v2y periodicity
    for i in np.arange(3,len(const_list0),2):
        const_list[i]=lambda_xx*(const_list0[i]+dconst_list[i])
        const_list[i+1]=lambda_yy*(const_list0[i+1]+dconst_list[i+1])
    #print(const_list0)
    return const_list


#defining the function to find free energy
def free_energy_function(x,phi_a,phi_b):
    temp=update_const_list(x)
    #print(x)
    k=0
    for i in np.arange(len(constraint_list)):
        constraint_list[i]=temp[k]
        k=k+1
    #print(constraint_list)
    ssp.Polygon.update_phis(phi_a,phi_b)
    ssp.Free_nodes.update_constraint_list()
    ssp.Periodic_nodes.periodicity_apply()
   # print(node7)
    fun=ssp.Polygon.free_energy_calc()
   # print(fun)
    return fun



def import_init_geometry(constraint_list, saveinitialimage):
    """
    Import initial geometry from a file and return the constraint list.
    """
    

    fig,ax=plt.subplots(1,1,figsize=(6,6))
    ssp.Polygon.plot_periodic_tiling(ax,2,2,constraint_list[0],constraint_list[1],constraint_list[2])
    ax.set_title('Free energy per chain: $f_c = {:.6f}$'.format(ssp.Polygon.free_energy_calc()))
    plt.tight_layout()    
    ax.grid(False)
    if saveinitialimage:    

        plt.savefig('plots/initial_geometry.png', format='png', dpi=300)
    plt.close(fig)
    
       
   

# Main script to execute the Strongly Segregated Polygon mode

def morphology_minimisation(constraint_list,phi_a, phi_b,saveminimisedimage):


    const_list0= constraint_list.copy()
    dconst_list=np.zeros(len(constraint_list))
    for i in np.arange(len(constraint_list)):
        dconst_list[i]=random.random()*0.005

  
    
    x0= dconst_list.copy()
    #print(x0) 

    j=minimize(free_energy_function, x0,args=(phi_a,phi_b),  options={'disp': True})

    ssp.Free_nodes.update_constraint_list()
    ssp.Periodic_nodes.periodicity_apply()

    fig,ax=plt.subplots(1,1,figsize=(6,6))
    ssp.Polygon.plot_periodic_tiling(ax,2,2,constraint_list[0],constraint_list[1],constraint_list[2])
    ax.set_title('Free energy per chain: $f_c = {:.6f}$'.format(ssp.Polygon.free_energy_calc()))
    plt.tight_layout()
    ax.grid(False)
    if saveminimisedimage:    

        plt.savefig('plots/minimised.png', format='png', dpi=300)
    plt.close(fig)
   


def main(filename,saveinitialimage,saveminimisedimage=True ):


    global const_list0, constraint_list, chiab, chibc, chiac, RD

    # Read initial geometry and set up
    constraint_list = read_geometry.read_in_node_values(filename)
    import_init_geometry(constraint_list, saveinitialimage)
    
    const_list0 = constraint_list.copy()

    # Extract parameters

    # phi_a and phi_b are the volume fractions of components A and B  monomers respectively.
    # Thesse values can be modified  here if needed.
    phi_a = ssp.Polygon.phi_a
    phi_b = ssp.Polygon.phi_b
    chiab, chibc, chiac, RD = ssp.Polygon.xi_ab, ssp.Polygon.xi_bc, ssp.Polygon.xi_ac, ssp.Polygon.R_D


    morphology_minimisation(constraint_list,phi_a, phi_b,saveminimisedimage)

    # Write the minimised geometry to a file
    # Uncomment the next line to save the minimised geometry
    # write_poly.polygon_write('geometry_output.txt', constraint_list)

def parse_args():
    parser = argparse.ArgumentParser(description="Execute Strongly Segregated Polygon mode minimisation.")
    parser.add_argument("filename", type=str, help="Path to the initial geometry file.")
    parser.add_argument("--saveinitialimage", action="store_true", help="Save the initial geometry image.")
    parser.add_argument("--saveminimisedimage", action="store_true", help="Save the minimised geometry image.")
    return parser.parse_args()

if __name__ == "__main__":
    args = parse_args()
    main(args.filename, saveinitialimage=args.saveinitialimage, saveminimisedimage=args.saveminimisedimage)

    """
    README

    # Strongly Segregated Polygon (SSP) Minimisation Script

    This script executes the minimisation of free energy for a given polygonal geometry using the Strongly Segregated Polygon (SSP) model.

    ## Requirements

    - Python 3.x
    - Required Python packages:
        - numpy
        - matplotlib
        - scipy

   

    ## Usage

    Open a terminal and run:

        python ssp_excecute.py <geometry_file> [--saveinitialimage] [--saveminimisedimage]

    - `<geometry_file>`: Path to the initial geometry file (required).
    - `--saveinitialimage`: Save an image of the initial geometry (optional).
    - `--saveminimisedimage`: Save an image of the minimised geometry (optional).

    ### Example

        python ssp_excecute.py input_geometry.txt --saveinitialimage --saveminimisedimage

    This will read `input_geometry.txt`, perform the minimisation, and save images of both the initial and minimised geometries in the `plots/` directory.

    """


    