from SSP import strongly_segregated_polygon as ssp

# This script writes the polygon structure to a file. 
# On creating a new moprphology from scratch, this script will be used to write the
#  initial structurre in the form of geometry file.


def polygon_write(filehandle,const_l):
    filehandle.write("#Phi values")
    filehandle.write('\n'+str(ssp.Polygon.phi_a)+' '+str(ssp.Polygon.phi_b))
    filehandle.write('\n'+"#Chi values")
    filehandle.write('\n'+str(ssp.Polygon.xi_ab)+' '+str(ssp.Polygon.xi_bc)+' '+str(ssp.Polygon.xi_ac))
    filehandle.write('\n'+"Rd"+' '+str(ssp.Polygon.R_D))
    filehandle.write('\n'+"#Periodicity from constraint list")
    for listitem in const_l:
        filehandle.write('\n'+listitem)
    filehandle.write('\n'+"#Number of vertices:")
    filehandle.write('\n' +str(ssp.SST_Vertex.vertex_count))
    filehandle.write('\n'+"#Initial values of vertices with its id:")
    for i in range(ssp.SST_Vertex.vertex_count):
        node=ssp.SST_Vertex.vertex_list[i]
        filehandle.write('\n' +str(node.id)+ ' '+ str(node.position[0])+ ' '+ str(node.position[1]))
    filehandle.write('\n'+"#Number of free nodes:")
    filehandle.write('\n' +str(ssp.Free_nodes.free_node_count))
    filehandle.write('\n'+"#Free nodes:")
    for i in range(ssp.Free_nodes.free_node_count):
        free_node=ssp.Free_nodes.free_node_list[i].vertex
        filehandle.write('\n' +str(free_node.id))
    filehandle.write('\n'+"#Number of periodic nodes:")
    filehandle.write('\n' +str(ssp.Periodic_nodes.periodic_node_count))
    filehandle.write('\n'+"#Periodic nodes:")
    for i in range(ssp.Periodic_nodes.periodic_node_count):
        periodic_nodes=ssp.Periodic_nodes.periodic_node_list[i]
        p_node1=periodic_nodes.vertex1
        p_node2=periodic_nodes.vertex2
        l=periodic_nodes.l
        m=periodic_nodes.m
        filehandle.write('\n' +str(p_node1.id)+ ' '+ str(p_node2.id)+' '+str(l)+' '+str(m))
    filehandle.write('\n'+"#Hexagon arrangement")
    filehandle.write('\n'+"#Number of polygons:")
    filehandle.write('\n' +str(ssp.Polygon.polygon_count))
    for i in range(ssp.Polygon.polygon_count):
        polygons=ssp.Polygon.polygon_list[i]
        poly_node1=polygons.vertex1
        poly_node2=polygons.vertex2
        poly_node3=polygons.vertex3
        poly_node4=polygons.vertex4
        poly_node5=polygons.vertex5
        poly_node6=polygons.vertex6
        filehandle.write('\n' +str(poly_node1.id)+ '  '+ str(poly_node2.id)+'  '+str(poly_node3.id)+'  '
                         +str(poly_node4.id)+'  '+str(poly_node5.id)+'  '+str(poly_node6.id))
