from SSP import strongly_segregated_polygon as ssp



# # This script reads the geometry file and returns the constraint list, polygons, and model parameters (Nχ's and φ's).
# It reads the txt file given in the geometry folder.
#This returns the final constraint list, which is used in the main script to create the model.
def read_in_node_values(filename=''):

    file1 = open(filename, 'r')
    Lines = file1.readlines()
    
    phivalues=str.split(Lines[1])
    phia,phib=float(phivalues[0]),float(phivalues[1])
    
    chivalues=str.split(Lines[3])
    chiab,chibc,chiac=float(chivalues[0]),float(chivalues[1]),float(chivalues[2])
    Rd=str.split(Lines[4])
    RD=float(Rd[1])
    constraint_list=[float(Lines[6]),float(Lines[7]),float(Lines[8])]

    number_of_vertices=int(Lines[10])

    node=[]
    thedict={}
    for i in range(number_of_vertices):
        node.append(ssp.SST_Vertex())
        node_values_string=str.split(Lines[12+i])
        node[i].position[0], node[i].position[1]=float(node_values_string[1]),float(node_values_string[2])
        thedict[i]=int(node_values_string[0])



    freenodelines_start_at=12+number_of_vertices+1
    number_of_freenodes=int(Lines[freenodelines_start_at])
    for i in range(number_of_freenodes):
        #node_values_string=str.split(Lines[freenodelines_start_at+2+i])
        node_id=int(Lines[freenodelines_start_at+2+i])
        ssp.Free_nodes(constraint_list,node[thedict[node_id]])

    periodicnodelines_start_at= freenodelines_start_at+2+number_of_freenodes+1

    number_of_periodicnodes=int(Lines[periodicnodelines_start_at])
    for i in range(number_of_periodicnodes):
        node_values_string=str.split(Lines[periodicnodelines_start_at+2+i])
        node_ida=int(node_values_string[0])
        node_idb=int(node_values_string[1])
        poly_l=float(node_values_string[2])
        poly_m=float(node_values_string[3])
        ssp.Periodic_nodes(node[thedict[node_ida]],node[thedict[node_idb]],constraint_list,poly_l,poly_m)
        
    ssp.Polygon.update_phis(phia,phib)
    ssp.Polygon.update_chisR_D(chiab,chibc,chiac,RD)
    polygonlines_start_at=periodicnodelines_start_at+2+number_of_periodicnodes+2
    number_of_polygons=int(Lines[polygonlines_start_at])
    for i in range(number_of_polygons):   
        poly_nodes=str.split(Lines[polygonlines_start_at+1+i])
        node1_id=int(poly_nodes[0])
        node2_id=int(poly_nodes[1])
        node3_id=int(poly_nodes[2])
        node4_id=int(poly_nodes[3])
        node5_id=int(poly_nodes[4])
        node6_id=int(poly_nodes[5])
        ssp.Polygon(node[thedict[node1_id]], node[thedict[node2_id]], node[thedict[node3_id]], 
                   node[thedict[node4_id]], node[thedict[node5_id]], node[thedict[node6_id]])
    return(constraint_list)
            

    
    	     
   	 
